IF EXISTS( SELECT * FROM SYS.OBJECTS 
			WHERE NAME ='TRG_EST_PROD_PRC_BANDEIRA_ALTERACAO_STATUS'AND TYPE = 'TR')
BEGIN
	DROP TRIGGER dbo.TRG_EST_PROD_PRC_BANDEIRA_ALTERACAO_STATUS 
END
GO 
CREATE TRIGGER TRG_EST_PROD_PRC_BANDEIRA_ALTERACAO_STATUS
ON
	EST_PROD_PRC_BANDEIRA
FOR INSERT, UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
    IF UPDATE(STS_PROD)
	BEGIN
		IF EXISTS (SELECT * FROM INSERTED WHERE STS_PROD = 1)
		BEGIN
			IF EXISTS (
				SELECT 
					* 
				FROM 
					INSERTED I
					INNER JOIN PRC_BANDEIRA_PRC_FILIAL BF ON
						I.CD_BANDEIRA = BF.CD_FILIAL
					INNER JOIN EST_PROD_CPL CPL ON
						I.CD_EMP = CPL.CD_EMP
						AND I.CD_PROD = CPL.CD_PROD
						AND BF.CD_FILIAL = CPL.CD_FILIAL
				WHERE
					CPL.CD_EMP = 1
					AND CPL.QT_EST <> 0)
			BEGIN
				RAISERROR ('Produto com estoque diferente de zero em alguma filial, nao podera ser inativado.',16, 1);   
				RETURN;
			END
		END
	END
END
GO